﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Fluke 6500-2(UK): (1 yr) VER RS-232/5320,DMM,M192(IEEE)
DATE:                  2014-12-11 14:24:35
AUTHOR:                Fluke
REVISION:              $Revision: 13288 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       136
CONFIGURATION:         Fluke 5320A
CONFIGURATION:         Digital Multimeter
CONFIGURATION:         Meatest M192
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.3 or later
#
#  Additional Equipment Required:
#        Variable Transformer:  240 V/50 Hz
#          Variac 3PN1020B or equivalent with UK line socket
#
#        Power Strip:  UK line sockets
#
#        Cable Adapter:  Line plug to 3 banana plugs
#          Fluke Part Number 2743368 (United Kingdom)
#
#        Cable Adapter:  Line socket (UK) to 110 V line plug
#        Cable Adapter:  110 V Line socket to PAT 110 V socket compatible plug
#          Fluke Part Number 4372377 (kit)
#
#        Adapter: Single banana (f) to alligator/crocodile clip
#          Fluke AC86 PN 2407510 (supplied with UUT)
#
#        USB Cable, 2 ea.
#        USB to USB Isolator (B&B Electronics UH401-2KV or equivalent)
#
#        Cable: Single banana (m) to single banana (m)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5320         Reset
  1.003  IEEE         [@DMM]
  1.003  IEEE         [@M192]
  1.004  ENDIF

  1.005  ASK-   R   Q N              P                            F        V

  1.006  IF           NOT(VERSIONCHECK("8.3.1"))
  1.007  END
  1.008  ENDIF

  1.009  CALL         Sub Fluke 6500-2 Required MET/CAL Version

  1.010  HEAD         PRELIMINARY INSTRUCTIONS
  1.011  CALL         Sub Display Copyright
  1.012  CALL         Sub High Voltage Safety Warning
  1.013  CALL         Sub Select Failed Test Mode
  1.014  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.015  DISP         Ambient temperature: 18 °C - 28 °C.
  1.015  DISP         Relative humidity: less than 80 %.

  1.016  MATH         @UUT_ModelNum    = "6500-2"; @ModelNum = @UUT_ModelNum
  1.017  MATH         @UUT_CountryCode = "UK"
  1.018  MATH         @MainsCable      = "Fluke PN 2743368 (UK)"
  1.019  MATH         @InterfaceCable  = "USB cable"

  1.020  CALL         Sub Fluke 6x00-2 RS-232 Command Definitions
  1.021  CALL         Sub Initialize /DMM
  1.022  MATH         @Connection = ""

  1.023  OPBR         -z Do you want to review the list of additional
  1.023  OPBR         equipment and/or accessories required?

  1.024  IF           MEM1
  1.025  CALL         Sub Fluke 6500-2(UK) Additional Equip Req (240 V Mains)
  1.026  CALL         Sub Fluke 6500-2(UK) Additional Equip Req (110 V Mains)
  1.027  ENDIF

  1.028  CALL         Sub Fluke 6500-2(AU,UK) 240 V Power On Self-Test VER
  1.029  JMPL         END                          @Error
  1.030  CALL         Sub Fluke 6x00-2 RS-232 Setup
  1.031  CALL         Sub Fluke 6x00-2 Query Identification RS-232
  1.032  JMPL         END                          @Error
  1.033  CALL         Sub Fluke 6x00-2 Check Identification
  1.034  JMPL         END                          @Error
  1.035  CALL         Sub Fluke 6x00-2(UK) (1 yr) 240 V Mains VER RS-232 /DMM
  1.036  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  1.037  CALL         Sub Fluke 6500-2(UK) (1 yr) Bond Test VER RS-232 /5320
  1.038  CALL         Sub Fluke 6500-2(UK) (1 yr) Insulation VER RS-232 /5320
  1.039  CALL         Sub Fluke 6500-2(UK) (1 yr) Sub Leakage VER RS-232/5320
  1.040  JMPL         LEAKAGE_CURRENT

  1.041  LABEL        TOUCH_CURRENT
  1.042  CALL         Sub Fluke 6500-2(UK) (1 yr) Touch Curr VER RS-232 /5320
  1.043  CALL         Sub Fluke 6500-2(UK) (1 yr) Load VER RS-232 /5320,M192i
  1.044  JMPL         RCD_CURRENT

  1.045  LABEL        LEAKAGE_CURRENT
  1.046  CALL         Sub Fluke 6500-2(UK) (1 yr) Leakage I VER RS-232 /5320
  1.047  JMPL         TOUCH_CURRENT

  1.048  LABEL        RCD_CURRENT
  1.049  CALL         Sub Fluke 6500-2(UK) (1 yr) RCD Curr VER RS-232 /5320
  1.050  CALL         Sub Fluke 6500-2 Get Mains Voltage /DMM
  1.051  CALL         Sub Fluke 6500-2(AU,UK) 110 V Power On Self-Test VER
  1.052  CALL         Sub Fluke 6x00-2 RS-232 Setup
  1.053  CALL         Sub Fluke 6500-2 (1 yr) 110 V Mains VER RS-232 /DMM
  1.054  CALL         Sub Fluke 6500-2(UK) (1 yr) Bond Test VER RS-232 /5320
  1.055  CALL         Sub Fluke 6500-2(UK) (1 yr) Insulation VER RS-232 /5320
  1.056  CALL         Sub 6500-2(UK) (1 yr) 110V Sub Leak VER RS-232/5320,DMM

  1.057  LABEL        END
  1.058  END
